<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Alan Adı Durumu Kontrolü</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-2.1.1.min.js" type="text/javascript"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>
    <link rel="stylesheet" href="styles.css"> <!-- Link to the new CSS file -->
        <script>
        function highlightTable(tableId, isChecked) {
            var table = document.getElementById(tableId);
            if (isChecked) {
                table.style.backgroundColor = "#404040"; // Seçildiğinde arkaplan rengini değiştir
            } else {
                table.style.backgroundColor = ""; // Seçim kaldırıldığında arkaplan rengini temizle
            }
        }

        function convertToPunycode(domain) {
            try {
                return new URL('http://' + domain).hostname;
            } catch (e) {
                return domain;
            }
        }

        $(document).ready(function(){
            $('#turkishInput').on('input', function(){
                var turkishText = $(this).val();
                if (turkishText === '') {
                    $('#domain').val('');
                } else {
                    var domains = turkishText.split(' ');
                    var punycodeDomains = domains.map(function(domain) {
                        return convertToPunycode(domain);
                    });
                    $('#domain').val(punycodeDomains.join(' '));
                }
            });

            // Butonların işlevleri
            $('#allExtensions').click(function() {
                $('.extension-item').show();
            });

            $('#standardExtensions').click(function() {
                $('.extension-item').hide();
                $('.extension-item[data-ozel="0"]').show();
            });

            $('#supExtensions').click(function() {
                $('.extension-item').hide();
                $('.extension-item[data-ozel="1"]').show();
            });

            // Show initial items and handle "Daha Fazla" button
            const itemsToShow = 12; // Number of items to show initially
            const itemsIncrement = 10; // Number of items to add each time "Daha Fazla" is clicked
            let currentlyVisible = itemsToShow;

            function showMoreItems() {
                $('.extension-item').slice(0, currentlyVisible).show();
            }

            // Initially hide all items, then show the first `itemsToShow` items
            $('.extension-item').hide();
            showMoreItems();

            $('#loadMore').click(function() {
                currentlyVisible += itemsIncrement;
                showMoreItems();

                // Hide the button if all items are visible
                if ($('.extension-item:visible').length === $('.extension-item').length) {
                    $('#loadMore').hide();
                }
            });

            // Toggle all extension checkboxes based on "Tümünü Seç" checkbox
            $('#selectAll').change(function() {
                var isChecked = $(this).prop('checked');
                $('.extension-item input[type="checkbox"]').prop('checked', isChecked);
            });
        });
    </script>
</head>
<body>
<div class="container">
    <div class="domain-box">
        <h2>Alan Adı Durumu Kontrolü</h2>
        <form action="" method="post">
            <fieldset>
                <legend>Alan Adı Sorgula</legend>
                <div class="form-group">
                    <label for="domain">Alan Adı:</label>
                    <input type="text" class="form-control" id="domain" name="domain" placeholder="Her kelime seçili uzantılarda bulunur" required>
                    <input type="submit" class="btn btn-primary" name="check" value="Sorgula">
                </div>
                <fieldset>
                    <legend>Uygun Uzantıları Seçin:</legend>
                    <div class="button-group">
                        <?php
                        include 'baglan.php'; // Veritabanı bağlantı dosyasını dahil et

                        // Veritabanından tüm alan adı uzantılarını, fiyatlarını ve ozel değerlerini seç
                        $sql = "SELECT extension, price, ozel FROM domains";
                        $result = $conn->query($sql);

                        // Initialize counters
                        $totalExtensions = 0;
                        $standardExtensions = 0;
                        $supExtensions = 0;

                        // Eğer sonuçlar varsa, tabloları oluştur
                        if ($result->num_rows > 0) {
                            while ($row = $result->fetch_assoc()) {
                                $ext = $row['extension']; // Uzantıyı al
                                $price = $row['price'];   // Fiyatı al
                                $ozel = $row['ozel'];     // Özel sütun değerini al

                                // Uzantı türüne göre sayacı artır
                                $totalExtensions++;
                                if ($ozel == 0) {
                                    $standardExtensions++;
                                } elseif ($ozel == 1) {
                                    $supExtensions++;
                                }
                            }
                        } else {
                            echo "Uygun uzantı bulunamadı.";
                        }

                        $conn->close(); // Veritabanı bağlantısını kapat
                        ?>
                        <label for="selectAll">
                            <input type="checkbox" id="selectAll" name="selectAll" value="ON">
                            Tümünü Seç
                        </label>
                        <button type="button" class="btn btn-secondary" id="allExtensions">Tümü (<?php echo $totalExtensions; ?>)</button>
                        <button type="button" class="btn btn-secondary" id="standardExtensions">Standart (<?php echo $standardExtensions; ?>)</button>
                        <button type="button" class="btn btn-secondary" id="supExtensions">Özel (<?php echo $supExtensions; ?>)</button>
                    </div>
                    <div class="extension-group">
                        <?php
                        include 'baglan.php'; // Veritabanı bağlantı dosyasını dahil et

                        // Veritabanından tüm alan adı uzantılarını, fiyatlarını ve ozel değerlerini seç
                        $sql = "SELECT extension, price, ozel FROM domains";
                        $result = $conn->query($sql);

                        // Eğer sonuçlar varsa, tabloları oluştur
                        if ($result->num_rows > 0) {
                            while ($row = $result->fetch_assoc()) {
                                $ext = $row['extension']; // Uzantıyı al
                                $price = $row['price'];   // Fiyatı al
                                $ozel = $row['ozel'];     // Özel sütun değerini al

                                echo "<div align='center' class='extension-item' data-ozel='$ozel'>";
                                echo "<table border='1' width='100%' id='table_$ext' class='extension-table'>";
                                echo "<tr>";
                                echo "<td align='center' style='background-color: #800000; color: white; font-weight: bold;'>$price ₺</td>"; // Fiyat kahverengi arka plan ve kalın yazı ile gösterildi
                                echo "</tr>";
                                echo "</table>";
                                echo "<input type='checkbox' id='$ext' name='extensions[]' value='$ext' class='form-check-input' onchange='highlightTable(\"table_$ext\", this.checked)'>";
                                echo "<label class='form-check-label' for='$ext'>$ext</label>";
                                echo "</div>";
                            }
                        } else {
                            echo "Uygun uzantı bulunamadı.";
                        }

                        $conn->close(); // Veritabanı bağlantısını kapat
                        ?>    
                    </div>
                    <div style="text-align: center; margin-top: 20px;">
                        <button type="button" class="btn btn-primary" id="loadMore">Daha Fazla</button>
                    </div>   
 
                </fieldset>
            </fieldset>

        </form>

        <?php
        if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['check'])) {
            if (!empty($_POST['domain']) && !empty($_POST['extensions'])) {
                $domain_names = explode(' ', trim($_POST['domain']));
                $extensions = $_POST['extensions'];
                
                echo "<table class='table table-bordered results-table'>";
                echo "<thead><tr><th>Domain</th><th>Durum</th><th>Fiyat (₺)</th><th>İşlem</th></tr></thead>";
                echo "<tbody>";

                foreach ($domain_names as $domain_name) {
                    foreach ($extensions as $ext) {
                        $name_domain = $domain_name . $ext;
                        
                        $converted_domain = idn_to_ascii($name_domain);
                        $original_domain = idn_to_utf8($converted_domain);
                        
                        include 'baglan.php';

                        $stmt = $conn->prepare("SELECT price FROM domains WHERE extension = ?");
                        $stmt->bind_param("s", $ext);
                        $stmt->execute();
                        $stmt->bind_result($price);
                        $stmt->fetch();
                        $stmt->close();
                        $conn->close();
                        
                        $status = (gethostbyname($converted_domain) != $converted_domain) ? 'Alınmış' : 'Mevcut';
                        
                        echo "<tr>";
                        if ($status == 'Alınmış') {
                            echo "<td><a href='http://$converted_domain' target='_blank'><span class='punycode'>$converted_domain</span> ($original_domain)</a></td>";
                        } else {
                            echo "<td><span class='punycode'>$converted_domain</span> ($original_domain)</td>";
                        }
                        echo "<td style='color:" . ($status == 'Alınmış' ? 'red' : 'green') . ";'>$status</td>";
                        echo "<td><span style='font-size: 18px; font-weight: bold;'>$price ₺</span></td>";

                        echo "<td>";
                        if ($status == 'Mevcut') {
                            echo "<form action='siparis.php' method='post'>";
                            echo "<input type='hidden' name='domain' value='$name_domain'>";
                            echo "<input type='hidden' name='price' value='$price'>";
                            echo "<input type='submit' class='btn btn-success' value='Satın Al'>";
                            echo "</form>";
                        }
                        echo "</td>";
                        echo "</tr>";
                    }
                }

                echo "</tbody></table>";
            } else {
                echo "<div class='alert alert-danger mt-3'>Hata: Alan Adı girmeli ve en az bir uzantı seçmelisiniz.</div>";
            }
        }
        ?>
    </div>
</div>

</body>
</html>
