<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Domain Availability Check</title>
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css">
    <script src="https://code.jquery.com/jquery-2.1.1.min.js" type="text/javascript"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>
    <style type="text/css">
        body {
            background-color: #f8f9fa;
        }
        .domain-box {
            margin-top: 50px;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            background-color: #fff;
        }
        .extension-group {
            display: flex;
            flex-wrap: wrap;
        }
        .extension-item {
            margin: 5px;
            flex: 1 1 calc(20% - 10px); /* 5 columns layout */
            display: flex;
            align-items: center;
        }
        .btn-primary {
            margin-top: 10px;
        }
        h2, legend {
            text-align: center;
            margin-bottom: 20px;
        }
        .results-table {
            margin-top: 20px;
        }
    </style>
</head>
<body>
<div class="container">
    <div class="domain-box">
        <h2>Check Domain Availability</h2>
        <form action="" method="post">
            <fieldset>
                <legend>Alan Adı Sorgula</legend>
                <div class="form-group">
                    <label for="domain">Alan Adı:</label>
                    <input type="text" class="form-control" id="domain" name="domain" placeholder="example" required>
                </div>

                <fieldset>
                    <legend>Uygun Uzantıları Seçin:</legend>
                    <div class="extension-group">
                        <?php
                        include 'baglan.php';

                        $sql = "SELECT extension, price FROM domains";
                        $result = $conn->query($sql);

                        if ($result->num_rows > 0) {
                            while ($row = $result->fetch_assoc()) {
                                $ext = $row['extension'];
                                echo "<div class='extension-item'>";
                                echo "<input type='checkbox' id='$ext' name='extensions[]' value='$ext' class='form-check-input'>";
                                echo "<label class='form-check-label' for='$ext'>$ext</label>";
                                echo "</div>";
                            }
                        }

                        $conn->close();
                        ?>
                    </div>
                </fieldset>
            </fieldset>
            <input type="submit" class="btn btn-primary" name="check" value="Check">
        </form>

        <?php
        if (isset($_POST['check'])) {
            if (!empty($_POST['domain']) && !empty($_POST['extensions'])) {
                $domain_names = explode(' ', trim($_POST['domain']));
                $extensions = $_POST['extensions'];
                
                echo "<table class='table table-bordered results-table'>";
                echo "<thead><tr><th>Domain</th><th>Status</th><th>Price (TL)</th></tr></thead>";
                echo "<tbody>";

                foreach ($domain_names as $domain_name) {
                    foreach ($extensions as $ext) {
                        $name_domain = $domain_name . $ext;
                        include 'baglan.php';
                        $stmt = $conn->prepare("SELECT price FROM domains WHERE extension = ?");
                        $stmt->bind_param("s", $ext);
                        $stmt->execute();
                        $stmt->bind_result($price);
                        $stmt->fetch();
                        $stmt->close();
                        $conn->close();
                        
                        if (gethostbyname($name_domain) != $name_domain) {
                            echo "<tr><td>$name_domain</td><td style='color:red;'>Taken</td><td>$price</td></tr>";
                        } else {
                            echo "<tr><td>$name_domain</td><td style='color:green;'>Available</td><td>$price</td></tr>";
                        }
                    }
                }

                echo "</tbody></table>";
            } else {
                echo "<div class='alert alert-danger mt-3'>Error: Enter Domain Name and select at least one suffix.</div>";
            }
        }
        ?>
    </div>
</div>
</body>
</html>
